// FOR_YOU:
// This is the main source of your plugin.
// It's in this source you'll type all your assembly or c++ code and all 
// the variables and memory zones you need.

// ************  Top/Header section ************
#include "stdafx.h"
#include <string.h>
#include <stdio.h>
#include <math.h>
#include "bass.h"		// prototypes for extra sound library: bass.dll
	// Following header files will be updated for every new version of 
	// the tomb_NextGeneration.dll, so it's better you don't change them
	//  because they will be replaced for any new update.

#include "Tomb_NextGeneration.h" // mnemonic constants defined in tomb_NextGeneration.dll
#include "structures.h" // structure of tomb4 program and trng dll
#include "DefTomb4Funct.h" // defines of tomb4 procedure prototypes
#include "functions.h"  // assigments of real tomb4 address to each tomb4 procedures
#include "macros.h"  // definition of macros

	// FOR_YOU:
	// While the followings are the headers you can use 
	// to type your structures, constants and new tomb4 procedures you 
	// discovered. 
	// Following files are only yours and trng will not ever change them:
#include "macros_mine.h"  // here you define your own macros
#include "constants_mine.h" // here you define your mnemonic constants
#include "structures_mine.h" // here you type your structure definitions
#include "Tomb4Discoveries_mine.h" // here type tomb4 procedures you discovered

#include "trng.h" // list of trng functions imported from trng.cpp source. 

#pragma warning( error : 4706 )
#pragma warning(disable: 4996)

// ************  Early function declarations ************

#define ZOMBIE_TORCH 0
#define FUEL_SWITCH 1
#define WATER_SWITCH 2
#define LOCKER_DOOR 3

#define CONTROL 0
#define CONTROL_NEXT 1
#define POOL 2
#define WATER_BUILDING 3
#define TUBES 4

#define FLOW 0
#define EXPLOSION 1

typedef void (__cdecl *TYPE_GetLaraCollisionInfo)(StrItemTr4 *pLara, StrCollisionLara *pCollision);
typedef int (__cdecl *TYPE_GetLaraJointPos)(StrPosizione *pPos, int joint);
typedef short (__cdecl *TYPE_CreateItem)(void);
typedef void (__cdecl *TYPE_InitialiseItem)(short ItemIndex);

TYPE_GetLaraCollisionInfo GetLaraCollisionInfo = (TYPE_GetLaraCollisionInfo) 0x422180;
TYPE_GetLaraJointPos GetLaraJointPos = (TYPE_GetLaraJointPos) 0x41D890;
TYPE_CreateItem CreateItem = (TYPE_CreateItem) 0x453840;
TYPE_InitialiseItem InitialiseItem = (TYPE_InitialiseItem) 0x453890;

// ************  Global Variables Section *************

// FOR_YOU:
// here you type the variables or memory zones you wish use in different
// C++ procedures.
// If you use the assembly you'll have to type ALL your variables in this
// section.
// for example if you wish have a 32 bits signed variable to store big
// numbers you can type:
// TYPE_HERE:
// int MyNumber;
// and then you can use it in asm in this way:
//		mov  eax, [MyNumber]
// or
//      mov eax, dword ptr [MyNumber]
// same speech for wide memory zones.
// If you wish having a memory zone of 13000 bytes you can type:
//  BYTE MyZone[13000];
// and then you can use it in this way:
//     mov  al, MyNumber[ecx]  ; read the ECXth byte and copy it in AL
// or also:
//     mov al, [MyNumber+ecx] ; same result of above instruction

// Variables and memory zone to TYPE_HERE:

HINSTANCE MyDllInstance=NULL;  // the instance handle of your dll

extern char BufferLog[4096]; // temporary global buffer to host error and warning messages

// FOR_YOU: If you mean create code patch (changes in tomb4 code to call your code in the plugin dll,
// you MUST change the MyTomb4PatcherAddress value (here below) 
// You can discover a free tomb4 zone using TrngPatcher program, with the 
// menu command "Tools->Get Assignment of Free Memory range"
// Note: choose an address, in the given range, terminating with hex 
// digits: 0,4,8, or C
// because it's usefull that the address was a multiple by 4
// If you chose an address used from other plugins you'll get an error and
// the game will be aborted
// note: if you don't mean use code patches you can let 0x0 in following line
DWORD MyTomb4PatcherAddress = 0x628278; // <- TYPE_HERE: the new address you chose
								
// this text will contain your plugin name (omitting .dll extension).
// it will be used to give a title to messagebox for error messages or warnings
char TexMyPluginName[80];  
// in this MyData structure you can store all global variables for your plugin
// you have to define them in structures_mine.h source inside structure "StrMyData" or for variable
// to save and restore in savegames, in "StrSavegameGlobalData" or "StrSavegameLocalData" structures
StrMyData MyData;

short TubeIndexes[10], TubeTypes[10], FlameIndexes[9], ItemIndexes[4], RoomIndexes[5], SoundIndexes[2];
bool Enabled;

// ************  Utilities section  ****************

void MagicalTorch(short ItemIndex)
{
	if (!Enabled || ItemIndex != ItemIndexes[ZOMBIE_TORCH])
		KillItem(ItemIndex);
}

int NewCeiling(void *pFloor, DWORD CordX, int CordY, DWORD CordZ)
{
	if (!Enabled)
		return GetCeiling(pFloor, CordX, CordY, CordZ);
	return -5892;
}

void NewFloor(StrItemTr4 *pLara, StrCollisionLara *pCollision)
{
	GetLaraCollisionInfo(pLara, pCollision);
	if (!Enabled)
		return;
	if (pLara->CordZ > 36000) {
		if (pLara->CordY > -3456)
			pCollision->VetInfoSettori[0].FloorDist = -4;
	} else {
		if (pLara->CordY > -2256)
			pCollision->VetInfoSettori[0].FloorDist = -4;
	}
}

int NewHeight(void *pFloor, DWORD CordX, int CordY, DWORD CordZ)
{
	if (!Enabled)
		return GetHeight(pFloor, CordX, CordY, CordZ);
	return Trng.pGlobTomb4->pAdr->pLara->CordY;
}

void TriggerItem(short ItemIndex)
{
	StrItemTr4 *pItem;

	pItem = &Trng.pGlobTomb4->pAdr->pVetItems[ItemIndex];
	pItem->FlagsMain = FITEM_CREATURE | FITEM_NOT_YET_ENABLED;
	pItem->Objectbuttons |= 0x3E00;
	AddActiveItem(ItemIndex);
}

bool FollowFlow(int (*Map)[10], int *Line, int *Column, int *PreviousLine, int *PreviousColumn)
{
	switch (Map[*Line][*Column]) {
	case 0:
		break;
	case 1:
		if (*Line > *PreviousLine) {
			++*Line;
			++*PreviousLine;
			if (Map[*Line][*Column] == 1 || Map[*Line][*Column] == 3)
				return true;
		} else {
			--*Line;
			--*PreviousLine;
			if (Map[*Line][*Column] == 1 || Map[*Line][*Column] == 4)
				return true;
		}
		break;
	case 2:
		if (*Column > *PreviousColumn) {
			++*Column;
			++*PreviousColumn;
			if (Map[*Line][*Column] == 2 || Map[*Line][*Column] == 3)
				return true;
		} else {
			--*Column;
			--*PreviousColumn;
			if (Map[*Line][*Column] == 2 || Map[*Line][*Column] == 4)
				return true;
		}
		break;
	case 3:
		if (*Line == *PreviousLine) {
			--*Line;
			++*PreviousColumn;
			if (Map[*Line][*Column] == 1 || Map[*Line][*Column] == 4)
				return true;
		} else {
			--*Column;
			++*PreviousLine;
			if (Map[*Line][*Column] == 2 || Map[*Line][*Column] == 4)
				return true;
		}
		break;
	case 4:
		if (*Line == *PreviousLine) {
			++*Line;
			--*PreviousColumn;
			if (Map[*Line][*Column] == 1 || Map[*Line][*Column] == 3)
				return true;
		} else {
			++*Column;
			--*PreviousLine;
			if (Map[*Line][*Column] == 2 || Map[*Line][*Column] == 3)
				return true;
		}
		break;
	}
	return false;
}

void CreateGrenade(DWORD X, int Y, DWORD Z, short Room)
{
	short ItemIndex;
	StrItemTr4 *pItem;

	ItemIndex = CreateItem();
	if (ItemIndex != -1) {
		pItem = &Trng.pGlobTomb4->pAdr->pVetItems[ItemIndex];
		pItem->Intensity1 = 49680;
		pItem->SlotID = SLOT_GRENADE;
		pItem->Room = Room;
		pItem->CordX = X;
		pItem->CordY = Y;
		pItem->CordZ = Z;
		pItem->Objectbuttons = 0x3E00;
		InitialiseItem(ItemIndex);
		pItem->OrientationH = 0;
		pItem->OrientationV = 0;
		pItem->OrientationT = 0;
		pItem->Health = 1;
	}
}

int TubeCounter(short ItemIndex)
{
	int Counter;

	for (Counter = 0; Counter < 10; ++Counter) {
		if (TubeIndexes[Counter] == ItemIndex)
			return Counter;
	}
	return -1;
}

// ************  Patcher Functions section  ***************
// Note: please, don't change or remove the C++ procedure you find here,
// because they are necessary to do work the plugin with the trng dll
// Anyway in many of these functions you can add your code

int PatchTorchKill(void)
{
	DWORD Offset = 0x457265;

	return ApplyCallPatch(&Offset, 1, (DWORD) MagicalTorch);
}

int PatchKnightsTemplar(void)
{
	BYTE Opcode = 0xEB;

	return ApplyCodePatch(0x41300F, &Opcode, 1);
}

int PatchPoleUp(void)
{
	DWORD Offsets[2] = {0x423DC4, 0x423C93};

	return ApplyCallPatch(Offsets, 2, (DWORD) NewCeiling);
}

int PatchPoleDown(void)
{
	DWORD Offset = 0x423E5D;

	return ApplyCallPatch(&Offset, 1, (DWORD) NewFloor);
}

int PatchPoleStat(void)
{
	BYTE Opcodes[11] = {0xB0, 0x00, 0xFF, 0x25, 0x78, 0x82, 0x62, 0x00, 0x90, 0x90, 0x90};

	return ApplyCodePatch(0x423CB3, Opcodes, 11);
}

int PatchPoleKeep(void)
{
	DWORD Offset = 0x423E9C;

	return ApplyCallPatch(&Offset, 1, (DWORD) NewHeight);
}

int PatchPoison(void)
{
	BYTE Opcodes[11] = {0xB0, 0x01, 0xFF, 0x25, 0x78, 0x82, 0x62, 0x00, 0x90, 0x90, 0x90};

	return ApplyCodePatch(0x48DBF3, Opcodes, 11);
}

int PatchGrenadeDamage(void)
{
	BYTE Opcodes[9] = {0xB0, 0x02, 0xFF, 0x25, 0x78, 0x82, 0x62, 0x00, 0x90};

	return ApplyCodePatch(0x42B271, Opcodes, 9);
}

// FOR_YOU: In this function you insert the callings of functions used to change tomb4 code
// You can get these functions, in the correct format, using Trng Core -> Asm Souce Editor -> Debugging menu
// program
// note: if there is a conflict the function will return "false"
// and the tomb4 program will abort with an error message
bool CreateMyCodePatches(void)
{
	// the call of the code patch to TYPE_HERE:
	// example: 
	// SET_PATCH(Path_RedirCollision)
	// to call the function Patch_RedirCollision() created with TrngPatcher program (command Assmembly->Create Dynamic Patch Generator)

	SET_PATCH(PatchTorchKill);
	SET_PATCH(PatchKnightsTemplar);
	SET_PATCH(PatchPoleUp);
	SET_PATCH(PatchPoleDown);
	SET_PATCH(PatchPoleStat);
	SET_PATCH(PatchPoleKeep);
	SET_PATCH(PatchPoison);
	SET_PATCH(PatchGrenadeDamage);

	return true;
}

// ************  Assembly Procedures section  ******************

// FOR_YOU: In the SubPatchArray you'll type all procedure names of your code in the dll you
// wish were called from tomb4 code.
// type them in the order of ax value. So first asm proc in the list, will be called
// with ax=0, while the second in the list will be called with ax=1 ect.

__declspec(naked) void PolePushLara(void)
{
	__asm {
		cmp BYTE PTR [Enabled], 0h
		je Normal
		cmp DWORD PTR [esi + 48h], 8CA0h
		jle Second
		cmp DWORD PTR [esi + 44h], 0FFFFF280h
		jg Skip
		jmp Normal
	Second:
		cmp DWORD PTR [esi + 44h], 0FFFFF730h
		jg Skip
	Normal:
		cmp DWORD PTR [edi], 0h
		jle Skip
		mov WORD PTR [esi + 10h], 65h
		mov eax, 423CBEh
		jmp eax
	Skip:
		mov eax, 423CC4h
		jmp eax
	}
}

__declspec(naked) void DistortedScreen(void)
{
	__asm {
		cmp BYTE PTR [MyData.Save.Local.Explosion], 0h
		jz Normal
		mov cx, 1000h
		mov eax, 48DBFEh
		jmp eax
	Normal:
		cmp cx, 100h
		jl Skip
		mov eax, 48DBFEh
		jmp eax
	Skip:
		mov eax, 48DCEFh
		jmp eax
	}
}

__declspec(naked) void GrenadeDamage(void)
{
	__asm {
		cmp BYTE PTR [MyData.Save.Local.Explosion], 0h
		jz Normal
		pop esi
		ret
	Normal:
		mov ax, WORD PTR [ecx + 22h]
		test ax, ax
		jle Dead
		mov edx, 42B27Ah
		jmp edx
	Dead:
		mov edx, 42B2B7h
		jmp edx
	}
}

void *SubPatchArray[] = {
	
// TYPE_HERE your asm procedure names to call from tomb4 code
	PolePushLara,
	DistortedScreen,
	GrenadeDamage,
	NULL
};


// ************  MainPatcher() asm procedure  *****************

// FOR_YOU: This is your main patcher procedure.
// All your patch in tomb4 code will call this procedure passing to it, in ax register,
// the number of subpatch to call

BEGIN_ASM_PROC(MainPatcher)
	and eax, 0ffh
	mov eax, dword ptr [SubPatchArray+eax*4];
	jmp eax
END_ASM_PROC



// ************  CallBack functions section  *****************

// TYPE_HERE: your callback function

void cbInitProgram(int NumberLoadedPlugins, char *VetPluginNames[]) 
{

	// save number of plugins (enclosed yours and the tomb_nextgeneration.dll ) and their names
	// these data will be used to locate IDs of any loaded plugins using FindPluginID() function
	Trng.TotPlugins = NumberLoadedPlugins;
	Trng.pVetPluginNames = VetPluginNames;

	// clear all my global variables
	ClearMemory(&MyData, sizeof(StrMyData));
}


void cbInitGame(void)
{
	// here you can initialize your global data for whole adventure
	// this procedure will be called only once, before loading title level


}

void cbInitLevel(void)
{
	// here you can initialize specific items of currnet level.
	// it will be called only once for level, when all items has been already initialized
	// and just a moment before entering in main game cycle.

	StrItemTr4 *pItem;
	int Counter, Number;

	if (*Trng.pGlobTomb4->pAdr->pLevelNow == 1 && Trng.pGlobTomb4->TotBigNumbers >= 40) {
		Number = 0;
		for (Counter = 0; Counter < 10; ++Counter) {
			TubeIndexes[Counter] = Trng.pGlobTomb4->VetBigNumbers[Number];
			++Number;
		}
		for (Counter = 0; Counter < 10; ++Counter) {
			TubeTypes[Counter] = Trng.pGlobTomb4->VetBigNumbers[Number];
			++Number;
		}
		for (Counter = 0; Counter < 9; ++Counter) {
			FlameIndexes[Counter] = Trng.pGlobTomb4->VetBigNumbers[Number];
			++Number;
		}
		for (Counter = 0; Counter < 4; ++Counter) {
			ItemIndexes[Counter] = Trng.pGlobTomb4->VetBigNumbers[Number];
			++Number;
		}
		for (Counter = 0; Counter < 5; ++Counter) {
			RoomIndexes[Counter] = Trng.pGlobTomb4->VetBigNumbers[Number];
			++Number;
		}
		for (Counter = 0; Counter < 2; ++Counter) {
			SoundIndexes[Counter] = Trng.pGlobTomb4->VetBigNumbers[Number];
			++Number;
		}
	} else {
		Enabled = false;
	}
	if (!Enabled)
		return;
	if (!MyData.Save.Local.FuelSwitchUsed) {
		pItem = &Trng.pGlobTomb4->pAdr->pVetItems[ItemIndexes[FUEL_SWITCH]];
		pItem->AnimationNow = Trng.pGlobTomb4->pAdr->pVetSlot[pItem->SlotID].IndexFirstAnim + 1;
		pItem->FrameNow = Trng.pGlobTomb4->pAdr->pVetAnimations[pItem->AnimationNow].FrameStart;
		pItem->StateIdCurrent = Trng.pGlobTomb4->pAdr->pVetAnimations[pItem->AnimationNow].StateId;
		pItem->StateIdNext = Trng.pGlobTomb4->pAdr->pVetAnimations[pItem->AnimationNow].StateId;
	}
	if (!MyData.Save.Local.WaterSwitchUsed) {
		pItem = &Trng.pGlobTomb4->pAdr->pVetItems[ItemIndexes[WATER_SWITCH]];
		pItem->AnimationNow = Trng.pGlobTomb4->pAdr->pVetSlot[pItem->SlotID].IndexFirstAnim + 1;
		pItem->FrameNow = Trng.pGlobTomb4->pAdr->pVetAnimations[pItem->AnimationNow].FrameStart;
		pItem->StateIdCurrent = Trng.pGlobTomb4->pAdr->pVetAnimations[pItem->AnimationNow].StateId;
		pItem->StateIdNext = Trng.pGlobTomb4->pAdr->pVetAnimations[pItem->AnimationNow].StateId;
	}
	for (Counter = 0; Counter < 10; ++Counter) {
		if (!MyData.Save.Local.Pushable[Counter])
			Trng.pGlobTomb4->pAdr->pVetItems[TubeIndexes[Counter]].CordY += 2;
	}
}

// called everytime player save the game (but also when lara move from a level to another HUB saving). 
// in this procedure your plugin will save its own data in savegame
// SavingType inform about the kind of saving it is happening (SAVT_... values)
// pAdrZone is a byte pointer where this procedure will save the address from where begin data to save in savegame
// this function will return the size of data to save
// note: It's better you don't change anything of this code. It will save byself of data you stored in MyData.Save
// structure. If you wish adding other variables to save, just you add new fields in Structures of MyData.Save 
DWORD cbSaveMyData(BYTE **pAdrZone, int SavingType)
{
	DWORD SizeData;
	int i;
	static WORD *pVetExtras;
	int TotNWords;
	int TotNewActions;


	if (SavingType & SAVT_COMPLETED) {
		// this call is not to save data but only it is a confirm that the previous saving has been completed
		// now we can free the temporary memory used to save the data in previous call
		if (pVetExtras != NULL) {
			FreeMemory(pVetExtras);
			pVetExtras=NULL;
		}

		return 0;
	}


	TotNWords=0;
	pVetExtras = (WORD *) GetMemory(16);
	// save id of my plugin in first word

	pVetExtras[TotNWords++] = Trng.IdMyPlugin;

	if (SavingType & SAVT_LOCAL_DATA) {
		// save local data

		// save Local structure
		AddNGToken(NGTAG_LOCAL_DATA, NO_ARRAY, sizeof(StrSavegameLocalData), &MyData.Save.Local, 
						&pVetExtras, &TotNWords);


		// save all (currently enabled) progressive actions
		// before saving, compact progressive action array to remove intermediate free records
		TotNewActions=0;

		for (i=0;i<MyData.TotProgrActions;i++) {
			if (MyData.VetProgrActions[i].ActionType != AXN_FREE) {

				MyData.VetProgrActions[TotNewActions] = MyData.VetProgrActions[i];

				TotNewActions++;
			}
		}
		// update new valuese after recompatting
		MyData.LastProgrActionIndex =0;
		MyData.TotProgrActions= TotNewActions;

		// store all progressive action records
		AddNGToken(NGTAG_PROGRESSIVE_ACTIONS, MyData.TotProgrActions, sizeof(StrProgressiveAction), 
				&MyData.VetProgrActions[0], &pVetExtras, &TotNWords);

	}

	if (SavingType & SAVT_GLOBAL_DATA) {
		// save global data
		AddNGToken(NGTAG_GLOBAL_DATA, NO_ARRAY, sizeof(StrSavegameGlobalData), &MyData.Save.Global , 
						&pVetExtras, &TotNWords);
	}
	// write final sequence
	AddTokenFinalSequence(&pVetExtras, &TotNWords);

	// return to trng the infos about start of memory where there are our data and their size:
	*pAdrZone = (BYTE *) pVetExtras;
	SizeData = TotNWords * 2;

	return SizeData;
	

}
// called when a savegame will be loaded (but also when lara move from a level to another)
// pAdrZone will point to memory zone with data just loaded from savegame
// SizeData is the size of data pointed by pAdrZone
// note: it's better you don't change anything of this code. It's alread thought to reload all data you saved in MyData.Save 
// structure. There is no need of changes by you
void cbLoadMyData(BYTE *pAdrZone, DWORD SizeData)
{

	WORD *pVetExtras;
	StrParseNGField  ParseField;
	int Indice;
	int i;
	WORD TotActions;

	
	pVetExtras = (WORD*) pAdrZone;

	Indice=0;

	while (ParseNgField(pVetExtras ,Indice, &ParseField)==true) {
		
		// recover different ng token
		switch (ParseField.Type) {
		case NGTAG_LOCAL_DATA:
			// local data
			memcpy(&MyData.Save.Local, ParseField.pData, sizeof(StrSavegameLocalData));
			break;

		case NGTAG_GLOBAL_DATA:
			// global data
			memcpy(&MyData.Save.Global, ParseField.pData, sizeof(StrSavegameGlobalData));
			break;
			
		case NGTAG_PROGRESSIVE_ACTIONS:
			// progressive actions
			i= ParseField.StartDataIndex;
			// read tot actions value
			TotActions = pVetExtras[i++];
			// copy all tot records
			memcpy(&MyData.VetProgrActions[0], &pVetExtras[i], sizeof(StrProgressiveAction) * TotActions);
			MyData.TotProgrActions = TotActions;
			break;
		}
		Indice= ParseField.NextIndex; 
	}

}
// free memory used to store all data about your customize commands loaded in previous level
void FreeMemoryCustomize(void)
{
	int i;

	for (i=0;i<MyData.BaseCustomizeMine.TotCustomize;i++) {
		FreeMemory(MyData.BaseCustomizeMine.pVetCustomize[i].pVetArg);
	}

	if (MyData.BaseCustomizeMine.TotCustomize > 0) {
		FreeMemory(MyData.BaseCustomizeMine.pVetCustomize);
		MyData.BaseCustomizeMine.TotCustomize=0;
	}


	MyData.BaseCustomizeMine.pVetCustomize=NULL;
}

// free memory used to store all data about your parameters commands loaded in previous level
void FreeMemoryParameters(void)
{
	int i;

	for (i=0;i<MyData.BaseParametersMine.TotParameters;i++) {
		FreeMemory(MyData.BaseParametersMine.pVetParameters[i].pVetArg);
	}

	if (MyData.BaseParametersMine.TotParameters > 0) {
		FreeMemory(MyData.BaseParametersMine.pVetParameters);
		MyData.BaseParametersMine.TotParameters=0;
	}

	MyData.BaseParametersMine.pVetParameters=NULL;
}

// this procedure will be called at end of any level
// you can type here code to free resources allocated for level (that quits now)
void FreeLevelResources(void)
{

	// free memory used to store all data about your customize commands loaded in previous level
	FreeMemoryCustomize();
	// free memory used to store all data about your parameters commands loaded in previous level
	FreeMemoryParameters();
	MyData.BaseAssignSlotMine.TotAssign=0;

}
// it will be called before beginning the loading for a new level.
// you can type here code to initialise all variables used for level (to clear old values changed by previous level)
// and to free resources allocated in old level since now we'are going to another new level.

void cbInitLoadNewLevel(void)
{
	int i;

	StrProgressiveAction *pAction;

	// clear all LOCAL variables
	ClearMemory(&MyData.Save.Local,sizeof(StrSavegameLocalData));

	// clear progressive actions
	pAction= &MyData.VetProgrActions[0];

	for (i=0;i<MyData.TotProgrActions;i++) {
		if (pAction->ActionType != AXN_FREE) {
			// here you could analise to free resoruce allocated from this specific action

			pAction->ActionType = AXN_FREE;
		}
	}

	MyData.TotProgrActions=0;
	MyData.LastProgrActionIndex=0;

	// here you can initialise other variables of MyData different than Local and progressive actions
	// free resources allocate in previous level
	FreeLevelResources();

	int Counter;

	MyData.Save.Local.AllowExplosion = false;
	MyData.Save.Local.Explosion = false;
	MyData.Save.Local.ExplosionFrame = 0;
	MyData.Save.Local.Point.CordX = 0;
	MyData.Save.Local.Point.CordY = 0;
	MyData.Save.Local.Point.CordZ = 0;
	MyData.Save.Local.UpdatedConnectionStates = false;
	MyData.Save.Local.FuelFlowState = 0;
	MyData.Save.Local.WaterFlowState = 0;
	MyData.Save.Local.FuelConnectionState = 1;
	MyData.Save.Local.WaterConnectionState = 2;
	for (Counter = 0; Counter < 11; ++Counter) {
		MyData.Save.Local.FuelConnection[Counter] = 0;
		MyData.Save.Local.WaterConnection[Counter] = 0;
	}
	for (Counter = 0; Counter < 10; ++Counter)
		MyData.Save.Local.Pushable[Counter] = false;
	MyData.Save.Local.FuelSwitchUsed = false;
	MyData.Save.Local.WaterSwitchUsed = false;
	for (Counter = 0; Counter < 10; ++Counter) {
		TubeIndexes[Counter] = -1;
		TubeTypes[Counter] = -1;
	}
	for (Counter = 0; Counter < 9; ++Counter)
		FlameIndexes[Counter] = -1;
	for (Counter = 0; Counter < 4; ++Counter)
		ItemIndexes[Counter] = -1;
	for (Counter = 0; Counter < 5; ++Counter)
		RoomIndexes[Counter] = -1;
	for (Counter = 0; Counter < 2; ++Counter)
		SoundIndexes[Counter] = -1;
	Enabled = true;
}



// this procedure will be called everytime a flipeffect of yours will be engaged
// you have to elaborate it and then return a TRET_.. value (most common is TRET_PERFORM_ONCE_AND_GO)
int cbFlipEffectMine(WORD FlipIndex, WORD Timer, WORD Extra, WORD ActivationMode)
{
	int RetValue;
	WORD TimerFull;

	RetValue = enumTRET.PERFORM_ONCE_AND_GO;
	// if the flip has no Extra paremeter you can handle a Timer value with values upto 32767
	// in this case you'll use the following TimerFull variable, where (with following code) we set a unique big number 
	// pasting togheter the timer+extra arguments:
	TimerFull = Timer | (Extra << 8);

	switch (FlipIndex) {
		// here type the "case Number:" for each flipeffect number. At end of the code you'll use the "break;" instruction to signal the code ending
		// Note: when you'll add your first "case Number:" then you can remove the following "case -1: and break;" instructions
	case -1: 
		break;
	default:
		SendToLog("WARNING: Flipeffect trigger number %d has not been handled in cbFlipEffectMine() function", FlipIndex);
		break;
	}

	// if there was the one-shot button enabled, return TRET_PERFORM_NEVER_MORE
	if (ActivationMode & enumSCANF.BUTTON_ONE_SHOT) RetValue= enumTRET.PERFORM_NEVER_MORE; 
	return RetValue;
}
// this procedure will be called everytime an action trigger of yours will be engaged 
// you have to elaborate it and then return a TRET_.. value (most common is TRET_PERFORM_ONCE_AND_GO)
int cbActionMine(WORD ActionIndex, int ItemIndex, WORD Extra, WORD ActivationMode)
{
	int RetValue;
	
	RetValue=TRET_PERFORM_ONCE_AND_GO;

	switch (ActionIndex) {
		// type here the code per your action trigger.
		// add "case Number:" and complete the code with "break;" instruction
	case -1:
		// note: remove this "case -1:" and its "break;" it has been added only to avoid warning messages about empty switch
		break;
	default:
		SendToLog("WARNING: action trigger number %d has not been handled in cbActionMine() function", ActionIndex);
		break;
	}
	
	// if there was the one-shot button enabled, return TRET_PERFORM_NEVER_MORE
	if (ActivationMode & enumSCANF.BUTTON_ONE_SHOT) RetValue= enumTRET.PERFORM_NEVER_MORE;
	return RetValue;


}

// this procedure will be called everytime a conditional trigger of yours will be engaged
// you have to elaborate it and then return a CTRET_.. value (most common is CTRET_ONLY_ONCE_ON_TRUE)
int cbConditionMine(WORD ConditionIndex, int ItemIndex, WORD Extra, WORD ActivationMode)
{
	int RetValue;
	
	RetValue=CTRET_ONLY_ONCE_ON_TRUE;

	switch (ConditionIndex){
		// type here the code for your condition trigger, inserting the code in the section
		// beginning with "case NumberOfAction:" and ending with row "break;"
	case -1:
		// note: remove this "case -1:" and its "break;" it has been added only to avoid warning messages about empty switch
		break;
	default:
		SendToLog("WARNING: condition trigger number %d has not been handled in cbConditionMine() function", ConditionIndex);
		break;


	}
	return RetValue;
	  
}

// this procedure vill be called for each Customize=CUST_... command read from script
// having one of yours CUST_ constant
// CustomizeValue will be the value of your CUST_ constant
// NumberOfItems will be the number of following Item (signed 16 bit values) following
// the CUST_ constant in the customize= script command
// pItemArray is the array with all NumberOfItems arguments of customize command
void cbCustomizeMine(WORD CustomizeValue, int NumberOfItems, short *pItemArray)
{
	// here you can replace this default management of anonymous customize commands
	// with your procedure where you can recognize each different CUST_ value and 
	// save its arguments in meaningful names fields, or elaboriting them immediatly
	// when it is possible (warning: in this moment nothing of level it has been yet loaded, excepting the script section)

	// ----- default management (optional)----
	// all customize values will be saved in MyData structure
	DWORD SizeMem;
	StrGenericCustomize *pMyCust;
	int TotCust;

	// ask memory to have another (new) record of StrGenericCustomize structure
	TotCust= MyData.BaseCustomizeMine.TotCustomize;
	TotCust++;
	SizeMem = TotCust * sizeof(StrGenericCustomize);
	MyData.BaseCustomizeMine.pVetCustomize = 
				(StrGenericCustomize *) ResizeMemory(MyData.BaseCustomizeMine.pVetCustomize, SizeMem);

	pMyCust = & MyData.BaseCustomizeMine.pVetCustomize[TotCust-1];
	
	// now require memory for all arguments (NumberOfItems) store in pItemArray

	pMyCust->pVetArg = (short *) GetMemory(2 * NumberOfItems);
	// copy data
	pMyCust->NArguments = NumberOfItems;
	memcpy(pMyCust->pVetArg, pItemArray, 2*NumberOfItems);
	pMyCust->CustValue = CustomizeValue;

	MyData.BaseCustomizeMine.TotCustomize= TotCust;
	// ---- end of default managemnt for generic customize -------------	
}
// callback called everytime in current level section of the script it has been found an AssignSlot command
// with one of your OBJ_ constants
void cbAssignSlotMine(WORD Slot, WORD ObjType)
{
	int i;

	i = MyData.BaseAssignSlotMine.TotAssign;

	if (i >= MAX_ASSIGN_SLOT_MINE) {
		SendToLog("ERROR: too many AssignSlot= commands for current plugin");
		return;
	}

	MyData.BaseAssignSlotMine.VetAssignSlot[i].MioSlot = Slot;
	MyData.BaseAssignSlotMine.VetAssignSlot[i].TipoSlot = ObjType;
	MyData.BaseAssignSlotMine.TotAssign++;

}
// this procedure vill be called for each Parameters=PARAM_... command read from script
// having one of yours PARAM_ constants
// ParameterValue will be the value of your PARAM_ constant
// NumberOfItems will be the number of following Item (signed 16 bit values) following
// the PARAM_ constant in the customize= script command
// pItemArray is the array with all NumberOfItems arguments of Parameter command
void cbParametersMine(WORD ParameterValue, int NumberOfItems, short *pItemArray)
{
	// here you can replace this default management of anonymous parameters commands
	// with your procedure where you can recognize each different Param_ value and 
	// save its arguments in meaningful names fields, or elaboriting them immediatly
	// when it is possible (warning: in this moment nothing of level it has been yet loaded, excepting the script section)

	// ----- default management (optional)----
	// all parameters values will be saved in MyData structure
	DWORD SizeMem;
	StrGenericParameters *pMyParam;
	int TotParam;

	// ask memory to have another (new) record of StrGenericparameters structure
	TotParam= MyData.BaseParametersMine.TotParameters;
	TotParam++;
	SizeMem = TotParam * sizeof(StrGenericParameters);
	MyData.BaseParametersMine.pVetParameters = 
		(StrGenericParameters *) ResizeMemory(MyData.BaseParametersMine.pVetParameters, SizeMem);

	pMyParam = & MyData.BaseParametersMine.pVetParameters[TotParam-1];
	
	// now require memory for all arguments (NumberOfItems) store in pItemArray

	pMyParam->pVetArg = (short *) GetMemory(2 * NumberOfItems);
	// copy data
	pMyParam->NArguments = NumberOfItems;
	memcpy(pMyParam->pVetArg, pItemArray, 2*NumberOfItems);

	MyData.BaseParametersMine.TotParameters= TotParam;
	// ---- end of default managemnt for generic parameters -------------


}

// this procedure will be called every game cycle (at begin of cycle)
void cbCycleBegin(void)
{

}

// Not yet linked! To link it add to RequireMyCallBacks() function the row:
//  	GET_CALLBACK(CB_CYCLE_END, 0, 0, cbCycleEnd);
// this procedure will be called everygame cycle, at end.
// you have to return a RET_CYCLE_ value
int cbCycleEnd(void)
{


	return RET_CYCLE_CONTINUE;	
}

// this function will be called for each your (common) progressive action to be peformed
void PerformMyProgrAction(StrProgressiveAction *pAction)
{


	switch (pAction->ActionType) {
// replace the "case -1:" with your first "case AXN_...:" progressive action to manage)		
	case -1:
		break;

	}

}
// callback called from trng for each frame in game cycle to perform your (common) progressive action
void cbProgrActionMine(void)
{
	int i;
	StrProgressiveAction *pAction;

	pAction = &MyData.VetProgrActions[0];
	for (i=0;i<MyData.TotProgrActions;i++) {
		if (pAction->ActionType != AXN_FREE) {
			PerformMyProgrAction(pAction);
		}
		pAction++;
	}


}
// inside this function you'll type call to functions to intialise your new objects or customize that olds.
// this callback will be called at start of loading new level and a bit after having started to load level data
void cbInitObjects(void) 
{
	Trng.pGlobTomb4->pAdr->pVetSlot[SLOT_KNIGHTS_TEMPLAR].Flags |= FSLOT_AMPHIBIOUS_CREATURE;
	Trng.pGlobTomb4->pAdr->pVetSlot[SLOT_KNIGHTS_TEMPLAR].Flags &= ~(FSLOT_HIT_BUT_NOT_HURT_BY_SHOTGUN | FSLOT_NO_DAMAGE_FOR_NO_EXPLOSIVE_AMMO);
}

int cbBurningTorchControl(short IndexItem, StrItemTr4 *pItem, WORD CBT_Flags)
{
	short Room;

	if (Enabled && !MyData.Save.Local.FuelFlowState && MyData.Save.Local.FuelConnectionState == 2 && pItem->Reserved_3A) {
		Room = pItem->Room;
		GetFloor(pItem->CordX, pItem->CordY, pItem->CordZ, &Room);
		if (Room == RoomIndexes[POOL]) {
			MyData.Save.Local.Explosion = true;
			MyData.Save.Local.Point.CordX = pItem->CordX;
			MyData.Save.Local.Point.CordY = pItem->CordY;
			MyData.Save.Local.Point.CordZ = pItem->CordZ;
		}
	}
	return SRET_OK;
}

int cbKnightsTemplarControl(short IndexItem, StrItemTr4 *pItem, WORD CBT_Flags)
{
	if (pItem->Health <= 0) {
		if (pItem->StateIdCurrent != 9) {
			pItem->AnimationNow = Trng.pGlobTomb4->pAdr->pVetSlot[SLOT_KNIGHTS_TEMPLAR].IndexFirstAnim + 13;
			pItem->FrameNow = Trng.pGlobTomb4->pAdr->pVetAnimations[pItem->AnimationNow].FrameStart;
			pItem->StateIdCurrent = 9;
			pItem->StateIdNext = 9;
		}
		AnimateItem(pItem);
		return SRET_SKIP_ORIGINAL;
	}
	return SRET_OK;
}

int cbLaraControl(WORD CBT_Flags, StrItemTr4 *pLara)
{
	StrPosizione Position;
	short Room;
	int Height, Matrix[10][10], Index[10][10], PreviousLine, PreviousColumn, Line, Column, Counter;
	StrItemTr4 *pItem;

	if (!Enabled)
		return SRET_OK;
	if (pLara->Room == RoomIndexes[TUBES]
			|| pLara->Room == RoomIndexes[CONTROL]
			|| pLara->Room == RoomIndexes[CONTROL_NEXT] && pLara->CordX < 47616) {
		for (Counter = 0; Counter < 10; ++Counter) {
			if (!MyData.Save.Local.Pushable[Counter])
				SoundEffect(SoundIndexes[FLOW], &Trng.pGlobTomb4->pAdr->pVetItems[TubeIndexes[Counter]].CordX, 0);
		}
	}
	if (pLara->Room == RoomIndexes[CONTROL]) {
		if (!MyData.Save.Local.UpdatedConnectionStates) {
			for (Line = 0; Line < 10; ++Line) {
				for (Column = 0; Column < 10; ++Column) {
					Matrix[Line][Column] = 0;
					Index[Line][Column] = 0;
				}
			}
			Matrix[1][5] = 1;
			Matrix[2][8] = 2;
			Matrix[4][4] = 2;
			Matrix[7][5] = 1;
			for (Counter = 0; Counter < 10; ++Counter) {
				pItem = &Trng.pGlobTomb4->pAdr->pVetItems[TubeIndexes[Counter]];
				Line = (pItem->CordZ - Trng.pGlobTomb4->pAdr->pVetRooms[RoomIndexes[TUBES]].OriginZ - 512) / 1024;
				Column = (pItem->CordX - Trng.pGlobTomb4->pAdr->pVetRooms[RoomIndexes[TUBES]].OriginX - 512) / 1024;
				Matrix[Line][Column] = TubeTypes[Counter];
				Index[Line][Column] = TubeIndexes[Counter];
			}
			PreviousLine = 0;
			PreviousColumn = 5;
			Line = 1;
			Column = 5;
			MyData.Save.Local.FuelConnectionState = 0;
			Counter = 0;
			while (FollowFlow(Matrix, &Line, &Column, &PreviousLine, &PreviousColumn)) {
				if (Line == 4 && Column == 4) {
					MyData.Save.Local.FuelConnectionState = 1;
					break;
				} else {
					if (Line == 7 && Column == 5) {
						MyData.Save.Local.FuelConnectionState = 2;
						break;
					}
				}
				MyData.Save.Local.FuelConnection[Counter] = Index[Line][Column];
				++Counter;
			}
			MyData.Save.Local.FuelConnection[Counter] = -1;
			Trng.pGlobTomb4->pAdr->pVetItems[ItemIndexes[FUEL_SWITCH]].OcbCode = MyData.Save.Local.FuelConnectionState ? 0 : -1;
			PreviousLine = 2;
			PreviousColumn = 9;
			Line = 2;
			Column = 8;
			MyData.Save.Local.WaterConnectionState = 0;
			Counter = 0;
			while (FollowFlow(Matrix, &Line, &Column, &PreviousLine, &PreviousColumn)) {
				if (Line == 4 && Column == 4) {
					MyData.Save.Local.WaterConnectionState = 1;
					break;
				} else {
					if (Line == 7 && Column == 5) {
						MyData.Save.Local.WaterConnectionState = 2;
						break;
					}
				}
				MyData.Save.Local.WaterConnection[Counter] = Index[Line][Column];
				++Counter;
			}
			MyData.Save.Local.WaterConnection[Counter] = -1;
			Trng.pGlobTomb4->pAdr->pVetItems[ItemIndexes[WATER_SWITCH]].OcbCode = MyData.Save.Local.WaterConnectionState ? 0 : -1;
			MyData.Save.Local.UpdatedConnectionStates = true;
		}
	} else {
		MyData.Save.Local.UpdatedConnectionStates = false;
	}
	if (!MyData.Save.Local.Explosion) {
		if (!MyData.Save.Local.FuelFlowState
				&& MyData.Save.Local.FuelConnectionState == 2
				&& *Trng.pGlobTomb4->pAdr->pFlagsLara & FL_HOLDS_FLARE_OR_TORCH
				&& *Trng.pGlobTomb4->pAdr->pFlagsLara2 & FL2_TORCH_IS_BURNING) {
			MyData.Save.Local.AllowExplosion = pLara->Room == RoomIndexes[POOL];
		}
		if (MyData.Save.Local.AllowExplosion) {
			Position.OrgX = -32;
			Position.OrgY = 64;
			Position.OrgZ = 256;
			GetLaraJointPos(&Position, 14);
			Room = pLara->Room;
			GetFloor(Position.OrgX, Position.OrgY, Position.OrgZ, &Room);
			if (Room == RoomIndexes[POOL]) {
				MyData.Save.Local.Explosion = true;
				MyData.Save.Local.Point.CordX = Position.OrgX;
				MyData.Save.Local.Point.CordY = Position.OrgY;
				MyData.Save.Local.Point.CordZ = Position.OrgZ;
			}
		}
	} else {
		if (!MyData.Save.Local.ExplosionFrame) {
			if (pLara->Health > 0) {
				pLara->AnimationNow = 438;
				pLara->FrameNow = Trng.pGlobTomb4->pAdr->pVetAnimations[438].FrameStart;
				pLara->StateIdCurrent = Trng.pGlobTomb4->pAdr->pVetAnimations[438].StateId;
				pLara->StateIdNext = Trng.pGlobTomb4->pAdr->pVetAnimations[438].StateId;
				*Trng.pGlobTomb4->pAdr->pFlagsLaraHands = 1;
			}
			PerformFlipeffect(NULL, 62, 0, 0);
			PerformFlipeffect(NULL, 68, SoundIndexes[EXPLOSION], 0);
			PerformFlipeffect(NULL, 130, 1, 0);
			CreateGrenade(MyData.Save.Local.Point.CordX, MyData.Save.Local.Point.CordY, MyData.Save.Local.Point.CordZ, RoomIndexes[POOL]);
			for (Counter = 0; Counter < 9; ++Counter) {
				TriggerItem(FlameIndexes[Counter]);
				pItem = &Trng.pGlobTomb4->pAdr->pVetItems[FlameIndexes[Counter]];
				CreateGrenade(pItem->CordX, pItem->CordY - 256, pItem->CordZ, pItem->Room);
			}
			*Trng.pGlobTomb4->pAdr->pFlashRed = 255;
			*Trng.pGlobTomb4->pAdr->pFlashGreen = 255;
			*Trng.pGlobTomb4->pAdr->pFlashBlue = 179;
			*Trng.pGlobTomb4->pAdr->pFlashDurate = 32;
		}
		Trng.pGlobTomb4->pAdr->pVetSlot[0].FootStep = 0;
		PerformFlipeffect(NULL, 1, 0, 0);
		TriggerDynamic(MyData.Save.Local.Point.CordX, MyData.Save.Local.Point.CordY, MyData.Save.Local.Point.CordZ, MyData.Save.Local.ExplosionFrame < 50 ? 5 * MyData.Save.Local.ExplosionFrame : 255, 255, 255, 179);
		PerformFlipeffect(NULL, 194, MyData.Save.Local.ExplosionFrame < 50 ? 100 + MyData.Save.Local.ExplosionFrame : 150, 0);
		PerformFlipeffect(NULL, 227, MyData.Save.Local.ExplosionFrame < 50 ? 90 + MyData.Save.Local.ExplosionFrame : 140, 0);
		Room = pLara->Room;
		Height = GetHeight(GetFloor(pLara->CordX, pLara->CordY, pLara->CordZ, &Room), pLara->CordX, pLara->CordY, pLara->CordZ);
		if (pLara->CordY > Height) {
			pLara->CordY = Height;
			pLara->FlagsMain &= ~FITEM_GRAVITY_AFFECTED;
		}
		if (MyData.Save.Local.ExplosionFrame == 120 && pLara->Health > 0)
			PerformFlipeffect(NULL, 4, 0, 0);
		++MyData.Save.Local.ExplosionFrame;
	}
	return SRET_OK;
}

int cbGrenadeDraw(short IndexItem, StrItemTr4 *pItem, WORD CBT_Flags)
{
	if (!pItem->Reserved_34)
		return SRET_SKIP_ORIGINAL;
	return SRET_OK;
}

int cbSwitchType6Control(short IndexItem, StrItemTr4 *pItem, WORD CBT_Flags)
{
	int Counter;
	bool *PushablePointer;

	if (!Enabled)
		return SRET_OK;
	if (IndexItem == ItemIndexes[FUEL_SWITCH]) {
		if (pItem->StateIdCurrent != MyData.Save.Local.FuelFlowState) {
			if (MyData.Save.Local.FuelConnectionState == 2) {
				FlipMap(Trng.pGlobTomb4->pAdr->pVetRooms[RoomIndexes[WATER_BUILDING]].FlipMapIndex);
				Trng.pGlobTomb4->pAdr->pVetItems[ItemIndexes[LOCKER_DOOR]].Objectbuttons &= ~0x3E00;
			}
			Counter = 0;
			while (MyData.Save.Local.FuelConnection[Counter] != -1) {
				PushablePointer = &MyData.Save.Local.Pushable[TubeCounter(MyData.Save.Local.FuelConnection[Counter])];
				Trng.pGlobTomb4->pAdr->pVetItems[MyData.Save.Local.FuelConnection[Counter]].CordY += 2 * (!pItem->StateIdCurrent - !*PushablePointer);
				*PushablePointer = !!pItem->StateIdCurrent;
				++Counter;
			}
			MyData.Save.Local.FuelSwitchUsed = true;
			MyData.Save.Local.FuelFlowState = pItem->StateIdCurrent;
		}
	} else {
		if (IndexItem == ItemIndexes[WATER_SWITCH]) {
			if (pItem->StateIdCurrent != MyData.Save.Local.WaterFlowState) {
				if (MyData.Save.Local.WaterConnectionState == 2)
					Trng.pGlobTomb4->pAdr->pVetRooms[RoomIndexes[WATER_BUILDING]].FlagsRoom ^= FROOM_WATER;
				Counter = 0;
				while (MyData.Save.Local.WaterConnection[Counter] != -1) {
					PushablePointer = &MyData.Save.Local.Pushable[TubeCounter(MyData.Save.Local.WaterConnection[Counter])];
					Trng.pGlobTomb4->pAdr->pVetItems[MyData.Save.Local.WaterConnection[Counter]].CordY += 2 * (!pItem->StateIdCurrent - !*PushablePointer);
					*PushablePointer = !!pItem->StateIdCurrent;
					++Counter;
				}
				MyData.Save.Local.WaterSwitchUsed = true;
				MyData.Save.Local.WaterFlowState = pItem->StateIdCurrent;
			}
		}
	}
	return SRET_OK;
}

// FOR_YOU:
// in this function RequireMyCallBacks() you'll type
// a list of:
//		GET_CALLBACK(CB_..., ,)
// one for each callback you need
bool RequireMyCallBacks(void)
{
// ************  RequireMyCallBacks() function  *****************
	// protype of GET_CALLBACK:
	// GET_CALLBACK(CallBackCB, CBT_Flags, Index, MyProcToCall)
	// default callbacks required always 
	GET_CALLBACK(CB_INIT_PROGRAM, 0, 0, cbInitProgram)
	GET_CALLBACK(CB_INIT_GAME, 0, 0, cbInitGame)
	GET_CALLBACK(CB_INIT_LEVEL, 0,0, cbInitLevel)
	GET_CALLBACK(CB_SAVING_GAME, 0, 0, cbSaveMyData)
	GET_CALLBACK(CB_LOADING_GAME, 0, 0, cbLoadMyData)
	GET_CALLBACK(CB_INIT_LOAD_NEW_LEVEL, 0,0, cbInitLoadNewLevel);
	GET_CALLBACK(CB_FLIPEFFECT_MINE, 0, 0, cbFlipEffectMine);
	GET_CALLBACK(CB_ACTION_MINE, 0,0, cbActionMine);
	GET_CALLBACK(CB_CONDITION_MINE,0,0,cbConditionMine);
	GET_CALLBACK(CB_CUSTOMIZE_MINE, 0,0, cbCustomizeMine);
	GET_CALLBACK(CB_PARAMETER_MINE, 0, 0, cbParametersMine);
	GET_CALLBACK(CB_ASSIGN_SLOT_MINE, 0,0, cbAssignSlotMine);
	GET_CALLBACK(CB_CYCLE_BEGIN, 0, 0, cbCycleBegin);
	GET_CALLBACK(CB_PROGR_ACTION_MINE, 0, 0, cbProgrActionMine);
	GET_CALLBACK(CB_INIT_OBJECTS, 0, 0, cbInitObjects);

	GET_CALLBACK(CB_SLOT_CONTROL, CBT_FIRST, SLOT_BURNING_TORCH_ITEM, cbBurningTorchControl);
	GET_CALLBACK(CB_SLOT_CONTROL, CBT_FIRST, SLOT_KNIGHTS_TEMPLAR, cbKnightsTemplarControl);
	GET_CALLBACK(CB_LARA_CONTROL, CBT_FIRST, 0, cbLaraControl);
	GET_CALLBACK(CB_SLOT_DRAW, CBT_FIRST, SLOT_GRENADE, cbGrenadeDraw);
	GET_CALLBACK(CB_SLOT_CONTROL, CBT_FIRST, SLOT_SWITCH_TYPE6, cbSwitchType6Control);

	return true;
}
// FOR_YOU:
// This function will be the first code to be executed of your plugin
// It happens when trng will load your plugin.
// In this moment no directX graphic is yet active, so you can show
// message boxes (TryMessageBox) to advise your players or level designer 
// about something
// Note: if you wish abort all (because there is an error or something
// is missing) you have to exit from this function returning: false
bool InitializeAll(void)
{
// ************  InitializeAll() function  ****************
	//  perform all your patches
	CALL_CHECK(CreateMyCodePatches)

	// call the function that requires all callback you need
	CALL_CHECK(RequireMyCallBacks)

	// TYPE_HERE: code to allocate global resource to use in the whole game

	return true;
}

// FOR_YOU: Tyis function will be called when tomb4 game is to be closed.
// you should type in this function further codes to free the global
// resource you had allocated in the InitializeAll() function 
void ReleaseAll(void)
{
// ************  ReleaseAll() function  ******************
	FreeLevelResources();
}


BOOL APIENTRY DllMain( HINSTANCE hInstanceDll, 
                       DWORD  ul_reason_for_call, 
                       LPVOID lpReserved)
{

    switch (ul_reason_for_call)
	{
		case DLL_PROCESS_ATTACH:
			MyDllInstance = hInstanceDll;
			GetTrngInfo();
			// control per check control value about size and alignment with globtomb4 structure
			if (CheckControlGlobTomb4() == false) return FALSE;

			if  (InitializeAll()==false) {
				return FALSE;
			}
			return TRUE;
			

		case DLL_PROCESS_DETACH:
			ReleaseAll();
			break;
    }
    return TRUE;
}


